clear 
close all

% You should change the directory to which you want to put the images
curentdir='C:\Users\Mehdi Rezagholizadeh\Desktop\Color Constancy\Synthesized Database';

img_ext='png';
out_dir=curentdir;


im_size=256;
surf_num=[4 9 16 25 36 49 64];
itr=1;

for ill_idx=1:87
    for j=1:length(surf_num)
        
        [IM,ill]=create_image(surf_num(j),im_size,ill_idx,0,0);
        groundtruth_illuminants(itr,:)=ill;
        img_names{itr}=sprintf('%s%d%s%d','SYN_ill',ill_idx,'srf',surf_num(j));
        fprintf(' Generating for %s\n',img_names{itr});
        pc_names{itr} = [out_dir '/' img_names{itr} '.' img_ext];
        imwrite(IM,pc_names{itr});
        itr=itr+1;
    end
end

all_image_names=img_names;
save('cc_gt_synt','all_image_names','groundtruth_illuminants')

